### 29.5.1. 连接Elasticsearch

你可以像其他Spring beans那样注入一个自动配置的ElasticsearchTemplate或Elasticsearch客户端实例。默认情况下，该实例将尝试连接到一个本地内存服务器（在Elasticsearch项目中的一个NodeClient），但你可以通过设置`spring.data.elasticsearch.clusterNodes`为一个以逗号分割的host:port列表来将其切换到一个远程服务器（比如，TransportClient）。
```java
@Component
public class MyBean {

    private ElasticsearchTemplate template;

    @Autowired
    public MyBean(ElasticsearchTemplate template) {
        this.template = template;
    }
    // ...
}
```
如果你添加一个你自己的ElasticsearchTemplate类型的@Bean，它将替换默认的。
